/**
 * An echo client. The client enters data to the server, and the
 * server echoes the data back to the client.
 */

import java.net.*;
import java.io.*;

public class EchoClient
{
	public static void main(String[] args) throws IOException {
		if (args.length < 2) {
			System.err.println("Usage: java EchoClient <IP address> <Port number>");
			System.exit(0);
		}

		BufferedReader in = null;
		PrintWriter out = null;
		BufferedReader fromUser = null;
		Socket sock = null;

		try {
			sock = new Socket(args[0], Integer.parseInt(args[1]));

			// set up the necessary communication channels
			in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
			fromUser = new BufferedReader(new InputStreamReader(System.in));
			out = new PrintWriter(sock.getOutputStream(),true);

			while (true) {
				String line = fromUser.readLine();
                                if (line == null || line.equals("bye")) 
                                {  
                                   out.println("bye");
                                   break;
                                }
				out.println(line);
                                System.out.println(in.readLine());
			}
		}
		catch (IOException ioe) {
			System.err.println(ioe);
		}
		finally {
			if (in != null)
				in.close();
			if (fromUser != null)
				fromUser.close();
			if (out != null)
				out.close();
			if (sock != null)
				sock.close();
		}
	}
}
